﻿use master
go
if exists (select name from sys.databases where name = 'DunyaDB')
begin
	alter database DunyaDB set single_user with rollback immediate -- veritabanı bağlantısını koparmak için özel sorgu
	drop database DunyaDB -- veritabanını silen esas sorgu
end
go
create database DunyaDB
go
USE [DunyaDB]
GO
/****** Object:  Table [dbo].[Kita]    Script Date: 21.06.2023 01:27:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Kita](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Adi] [varchar](200) NOT NULL,
 CONSTRAINT [PK_Kita] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[KitaUlkeSehir]    Script Date: 21.06.2023 01:27:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[KitaUlkeSehir](
	[KitaId] [int] NOT NULL,
	[UlkeId] [int] NOT NULL,
	[SehirId] [int] NOT NULL,
 CONSTRAINT [PK_KitaUlkeSehir_1] PRIMARY KEY CLUSTERED 
(
	[KitaId] ASC,
	[UlkeId] ASC,
	[SehirId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Sehir]    Script Date: 21.06.2023 01:27:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Sehir](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Adi] [varchar](150) NOT NULL,
 CONSTRAINT [PK_Sehir] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Ulke]    Script Date: 21.06.2023 01:27:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Ulke](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Adi] [varchar](300) NOT NULL,
	[Nufusu] [bigint] NULL,
	[Kisaltmasi] [varchar](20) NULL,
 CONSTRAINT [PK_Ulke] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[Kita] ON 
GO
INSERT [dbo].[Kita] ([Id], [Adi]) VALUES (1, N'Asya')
GO
INSERT [dbo].[Kita] ([Id], [Adi]) VALUES (2, N'Avrupa')
GO
INSERT [dbo].[Kita] ([Id], [Adi]) VALUES (3, N'Kuzey Amerika')
GO
SET IDENTITY_INSERT [dbo].[Kita] OFF
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (1, 1, 1)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (1, 1, 2)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (1, 1, 3)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (2, 1, 2)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (2, 3, 6)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (2, 3, 7)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (3, 2, 4)
GO
INSERT [dbo].[KitaUlkeSehir] ([KitaId], [UlkeId], [SehirId]) VALUES (3, 2, 5)
GO
SET IDENTITY_INSERT [dbo].[Sehir] ON 
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (1, N'Ankara')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (2, N'İstanbul')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (3, N'İzmir')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (4, N'New York')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (5, N'San Francisco')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (6, N'Berlin')
GO
INSERT [dbo].[Sehir] ([Id], [Adi]) VALUES (7, N'Frankfurt')
GO
SET IDENTITY_INSERT [dbo].[Sehir] OFF
GO
SET IDENTITY_INSERT [dbo].[Ulke] ON 
GO
INSERT [dbo].[Ulke] ([Id], [Adi], [Nufusu], [Kisaltmasi]) VALUES (1, N'Türkiye', 83000000, N'TR')
GO
INSERT [dbo].[Ulke] ([Id], [Adi], [Nufusu], [Kisaltmasi]) VALUES (2, N'Amerika Birleşik Devletleri', NULL, N'ABD')
GO
INSERT [dbo].[Ulke] ([Id], [Adi], [Nufusu], [Kisaltmasi]) VALUES (3, N'Almanya', 80000000, N'DE')
GO
SET IDENTITY_INSERT [dbo].[Ulke] OFF
GO
ALTER TABLE [dbo].[KitaUlkeSehir]  WITH CHECK ADD  CONSTRAINT [FK_KitaUlkeSehir_Kita] FOREIGN KEY([KitaId])
REFERENCES [dbo].[Kita] ([Id])
GO
ALTER TABLE [dbo].[KitaUlkeSehir] CHECK CONSTRAINT [FK_KitaUlkeSehir_Kita]
GO
ALTER TABLE [dbo].[KitaUlkeSehir]  WITH CHECK ADD  CONSTRAINT [FK_KitaUlkeSehir_Sehir] FOREIGN KEY([SehirId])
REFERENCES [dbo].[Sehir] ([Id])
GO
ALTER TABLE [dbo].[KitaUlkeSehir] CHECK CONSTRAINT [FK_KitaUlkeSehir_Sehir]
GO
ALTER TABLE [dbo].[KitaUlkeSehir]  WITH CHECK ADD  CONSTRAINT [FK_KitaUlkeSehir_Ulke] FOREIGN KEY([UlkeId])
REFERENCES [dbo].[Ulke] ([Id])
GO
ALTER TABLE [dbo].[KitaUlkeSehir] CHECK CONSTRAINT [FK_KitaUlkeSehir_Ulke]
GO
